% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.easycormatrix.R
\name{plot.see_easycormatrix}
\alias{plot.see_easycormatrix}
\title{Plot method for correlation matrices}
\usage{
\method{plot}{see_easycormatrix}(
  x,
  show_values = FALSE,
  show_p = FALSE,
  show_legend = TRUE,
  size = 1,
  text_size = 3.5,
  digits = 3,
  type = c("circle", "tile"),
  ...
)
}
\arguments{
\item{x}{An object.}

\item{show_values}{Logical, if \code{TRUE}, values are displayed.}

\item{show_p}{Logical, if \code{TRUE}, p-values or significant level is displayed.}

\item{show_legend}{Logical, show or hide legend.}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{text_size}{Size of text labels.}

\item{digits}{Number of decimals used for values.}

\item{type}{Character vector, indicating the type of plot.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{correlation::correlation()} function.
}
\examples{
library(correlation)
data(mtcars)
result <- correlation(mtcars[, -c(8:9)])
s <- summary(result)
plot(s)
}
