% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynElasticNet.R
\name{optimal_control_gradient_descent}
\alias{optimal_control_gradient_descent}
\title{estimating the optimal control using the dynamic elastic net}
\usage{
optimal_control_gradient_descent(
  alphaStep,
  armijoBeta,
  x0,
  parameters,
  alpha1,
  alpha2,
  measData,
  constStr,
  SD,
  modelFunc,
  measFunc,
  modelInput,
  optW,
  origAUC,
  maxIteration,
  plotEsti,
  conjGrad,
  eps,
  nnStates,
  verbose
)
}
\arguments{
\item{alphaStep}{starting value of the stepsize for the gradient descent, will be calculate to minimize the cost function by backtracking algorithm}

\item{armijoBeta}{scaling of the alphaStep to find a approximately optimal value for the stepsize}

\item{x0}{initial state of the ode system}

\item{parameters}{parameters of the ODE-system}

\item{alpha1}{L1 cost term scalar}

\item{alpha2}{L2 cost term scalar}

\item{measData}{measured values of the experiment}

\item{constStr}{a string that represents constrains, can be used to calculate a hidden input for a component that gradient is zero}

\item{SD}{standard deviation of the experiment; leave empty if unknown; matrix should contain the timesteps in the first column}

\item{modelFunc}{function that describes the ODE-system of the model}

\item{measFunc}{function that maps the states to the outputs}

\item{modelInput}{an dataset that describes the external input of the system}

\item{optW}{vector that indicated at which knots of the network the algorithm should estimate the hidden inputs}

\item{origAUC}{AUCs of the first optimization; only used by the algorithm}

\item{maxIteration}{a upper bound for the maximal number of iterations}

\item{plotEsti}{boolean that controls of the current estimates should be plotted}

\item{conjGrad}{boolean that indicates the usage of conjugate gradient method over the normal steepest descent}

\item{eps}{citeria for stopping the algorithm}

\item{nnStates}{a bit vector indicating the states that should be non negative}

\item{verbose}{Boolean indicating if an output in the console should be created to display the gradient descent steps}
}
\value{
A list containing the estimated hidden inputs, the AUCs, the estimated states and resulting measurements and the cost function
}
\description{
estimating the optimal control using the dynamic elastic net
}
