% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seek.R
\name{seek_lines}
\alias{seek_lines}
\title{Read and Prepare Matching Lines}
\usage{
seek_lines(files, pattern, ..., path, relative_path, matches)
}
\arguments{
\item{files}{A character vector of files to search (only for \code{seek_in()}).}

\item{pattern}{A regular expression pattern used to match lines.}

\item{...}{Additional arguments passed to \code{\link[readr:read_lines]{readr::read_lines()}}, such as
\code{skip}, \code{n_max}, or \code{locale}.}

\item{path}{A character vector of one or more directories where files should be
discovered (only for \code{seek()}).}

\item{relative_path}{Logical. If TRUE, file paths are made relative to the
path argument. If multiple root paths are provided, relative_path is
automatically ignored and absolute paths are kept to avoid ambiguity.}

\item{matches}{Logical. If \code{TRUE}, all matches per line are also returned in a
\code{matches} list-column.}
}
\value{
A tibble with one row per matching line.
}
\description{
Reads a set of files, filters lines based on a regular expression pattern,
and constructs a tidy tibble of the results.
}
\keyword{internal}
