% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_pc_coef.R
\docType{methods}
\name{gen_pc_coef-class}
\alias{gen_pc_coef-class}
\alias{gen_pc_coef}
\alias{gen_pc_coef-methods}
\alias{gen_pc_coef,simMGarch-method}
\title{A method to generate piecewise constant coefficients}
\usage{
gen_pc_coef(object, coef)

\S4method{gen_pc_coef}{simMGarch}(object, coef)
}
\arguments{
\item{object}{A \code{simMGarch} object.}

\item{coef}{A vector of coefficients.}
}
\description{
An auxilliary method to calculate piecewise constant coefficients for a user-specified vector of coefficients. The change-points are controlled
by the \code{changepoints} slot in the \code{simMGarch} object.
}
\examples{
pw.CCC.obj <- new("simMGarch")
coef.vector <- gen_pc_coef(pw.CCC.obj,c(0.2,0.4))
ts.plot(coef.vector,main="piecewise constant coefficients",ylab="coefficient",xlab="time")
}
\references{
Cho, Haeran, and Karolos Korkas. "High-dimensional GARCH process segmentation with an application to Value-at-Risk." arXiv preprint arXiv:1706.01155 (2018).
}
