% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.segmag}
\alias{plot.segmag}
\title{Plot segmentation magnitude}
\usage{
\method{plot}{segmag}(x, cutoffs = NULL, eb_times = NULL,
  segmag_substract = NULL, save_as_png = NULL, ...)
}
\arguments{
\item{x}{object of class \code{\link{segmag}}}

\item{cutoffs}{numeric vector of critical cutoffs that are drawn as horizontal
red lines. Use \code{\link{bootstrap_critical_cutoffs}} in order to
determine the cutoffs for a specific segmag object.}

\item{eb_times}{numeric vector of event boundary times to highlight in the plot}

\item{segmag_substract}{object of class \code{\link{segmag}}. If this value is set
than the difference in segmentation magnitude of
segmag - segmag_substract is drawn.}

\item{save_as_png}{string, optional name of file where to save plot (.png is added automatically)}

\item{...}{paramters passed to generic plot function}
}
\description{
Draws a plot depicting the segmentation magnitude resulting from overlaid
Gaussians for each key press time across participants. If segmag_substract
is defined then the difference in segmentation magnitude of segmag - segmag_substract
is drawn.
}
\seealso{
\code{\link{segmag}}
}

