% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual.R
\name{mutual_local}
\alias{mutual_local}
\title{Calculates local segregation indices based on M}
\usage{
mutual_local(
  data,
  group,
  unit,
  weight = NULL,
  se = FALSE,
  CI = 0.95,
  n_bootstrap = 100,
  base = exp(1),
  wide = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the dimension
over which segregation is computed.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the group for which local
segregation indices are calculated.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{se}{If \code{TRUE}, the segregation estimates are bootstrapped to provide
standard errors and to apply bias correction. The bias that is reported
has already been applied to the estimates (i.e. the reported estimates are "debiased")
(Default \code{FALSE})}

\item{CI}{If \code{se = TRUE}, compute the confidence (CI*100)% confidence interval
in addition to the bootstrap standard error.
This is based on percentiles of the bootstrap distribution, and a valid interpretation
relies on a larger number of bootstrap iterations. (Default \code{0.95})}

\item{n_bootstrap}{Number of bootstrap iterations. (Default \code{100})}

\item{base}{Base of the logarithm that is used in the calculation.
Defaults to the natural logarithm.}

\item{wide}{Returns a wide dataframe instead of a long dataframe.
(Default \code{FALSE})}
}
\value{
Returns a data.table with two rows for each category defined by \code{unit},
  for a total of \code{2*(number of units)} rows.
  The column \code{est} contains two statistics that
  are provided for each unit: \code{ls}, the local segregation score, and
  \code{p}, the proportion of the unit from the total number of cases.
  If \code{se} is set to \code{TRUE}, an additional column \code{se} contains
  the associated bootstrapped standard errors, an additional column \code{CI} contains
  the estimate confidence interval as a list column, an additional column \code{bias} contains
  the estimated bias, and the column \code{est} contains the bias-corrected estimates.
  If \code{wide} is set to \code{TRUE}, returns instead a wide dataframe, with one
  row for each \code{unit}, and the associated statistics in separate columns.
}
\description{
Returns local segregation indices for each category defined
by \code{unit}.
}
\examples{
# which schools are most segregated?
(localseg <- mutual_local(schools00, "race", "school",
    weight = "n", wide = TRUE
))

sum(localseg$p) # => 1

# the sum of the weighted local segregation scores equals
# total segregation
sum(localseg$ls * localseg$p) # => .425
mutual_total(schools00, "school", "race", weight = "n") # M => .425
}
\references{
Henri Theil. 1971. Principles of Econometrics. New York: Wiley.

Ricardo Mora and Javier Ruiz-Castillo. 2011.
  "Entropy-based Segregation Indices". Sociological Methodology 41(1): 159–194.
}
