% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/votes_match_deputies_ids.R
\name{votes_match_deputies_ids}
\alias{votes_match_deputies_ids}
\title{Matching deputies to theirs' ids}
\usage{
votes_match_deputies_ids(dbname, user, password, host, page,
   windows = .Platform$OS.type == 'windows')
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{page}{club's voting's results page}

\item{windows}{information of used operation system;
default: .Platform$OS.type == 'windows'}
}
\value{
data frame with three columns: deputy, vote, id
}
\description{
Function \code{votes_match_deputies_ids} matches deputies from voting's results
page to theirs' ids from \emph{deputies} table.
}
\details{
Function \code{votes_match_deputies_ids} matches deputies from voting's results
page to theirs' ids from \emph{deputies} table. The result of this function is
a data frame with deputies' data, ids and votes. Because of encoding issue
on Windows operation system, you need to select if you use Windows.
Example of page with voting's results of PO club:
http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?
symbol=klubglos&IdGlosowania=37494&KodKlubu=PO
}
\note{
All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
page <- paste0('http://www.sejm.gov.pl/Sejm7.nsf/agent.xsp?',
             'symbol=klubglos&IdGlosowania=37494&KodKlubu=PO')
votes_match_deputies_ids(dbname, user, password, host, page, TRUE)
votes_match_deputies_ids(dbname, user, password, host, page, FALSE)}
}
\author{
Piotr Smuda
}

