% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commandContexts.R, R/commandContextsDoc.R
\name{switchToParentFrame}
\alias{switchToParentFrame}
\title{Change focus to the parent context.}
\usage{
switchToParentFrame(remDr, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
invisible(remDr): An object of class "rDriver" is invisibly returned.
   A remote driver object see \code{\link{remoteDr}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{switchToParentFrame} Change focus to the parent context. If the current context is the top level browsing context, the context remains unchanged.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% getWindowHandle() # The current window handle
  remDr \%>\% getWindowHandles() # All windows in the session

  # Get the window position
  remDr \%>\% getWindowPosition

  # Some browsers are still using the old JSON wire end points
  remDr \%>\% getWindowPositionOld

  # Get the size of the window
  remDr \%>\% getWindowSize

  # Some browsers are still using the old JSON wire end points
  # remDr \%>\% getWindowSizeOld

  # Set the window size
  remDr \%>\% setWindowSize(500, 500)

  # Some browsers are still using the old JSON wire end points
  remDr \%>\% setWindowSizeOld(500, 500)

  # Set the position of the window
  remDr \%>\% setWindowPositionOld(400, 100)

  # Some browsers are still using the old JSON wire end points
  # remDr \%>\% setWindowPositionOld(400, 100)

  # Maximise the window
  remDr \%>\% maximizeWindow
  # Some browsers are still using the old JSON wire end points
  # remDr \%>\% maximizeWindowold()

  remDr \%>\% go("http://www.google.com/ncr")
  # search for the "R project"

  remDr \%>\% findElement("name", "q") \%>\% elementSendKeys("R project", key = "enter")

  webElem <- remDr \%>\% findElement("css", "h3.r a")

  remDr \%>\% deleteSession
}
}
\seealso{
Other commandContexts functions: \code{\link{closeWindow}},
  \code{\link{fullscreenWindow}},
  \code{\link{getWindowHandles}},
  \code{\link{getWindowHandle}},
  \code{\link{getWindowPosition}},
  \code{\link{getWindowSize}},
  \code{\link{maximizeWindow}},
  \code{\link{setWindowPosition}},
  \code{\link{setWindowSize}}, \code{\link{switchToFrame}},
  \code{\link{switchToWindow}}
}

