% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_fun.R
\name{bootCI}
\alias{bootCI}
\title{Bootstrap Confidence Intervals}
\usage{
bootCI(mod, conf = 0.95, type = "bca", digits = 3, bci.arg = NULL, ...)
}
\arguments{
\item{mod}{A fitted model object. Alternatively, a boot object (class
\code{"boot"}), containing bootstrapped model effects. Can also be a list
or nested list of such objects.}

\item{conf}{A numeric value specifying the confidence level for the
intervals.}

\item{type}{The type of confidence interval to return (defaults to
\code{"bca"} - see Details). See \code{\link[boot]{boot.ci}} for further
specification details.}

\item{digits}{The number of significant digits to return for numeric values.}

\item{bci.arg}{A named list of any additional arguments to \code{boot.ci},
excepting argument \code{index}.}

\item{...}{Arguments to \code{bootEff}.}
}
\value{
A data frame of the effects and bootstrapped confidence intervals, or
  a list or nested list of same.
}
\description{
Calculate confidence intervals from bootstrapped model effects.
}
\details{
This is essentially a wrapper for \code{boot.ci} from the \pkg{boot}
  package, returning confidence intervals of the specified type and level
  calculated from bootstrapped model effects. If a model or models is
  supplied, bootstrapping will first be performed via \code{bootEff}. Effects
  for which the confidence intervals do not contain zero are highlighted with
  a star.

  Nonparametric bias-corrected and accelerated confidence intervals
  (BC\emph{a}, Efron 1987) are calculated by default, which should provide
  the most accurate coverage across a range of bootstrap sampling
  distributions (Puth \emph{et al.} 2015). They will, however, be
  \href{https://stackoverflow.com/questions/7588388/adjusted-bootstrap-confidence-intervals-bca-with-parametric-bootstrap-in-boot}{inappropriate}
  for parametric resampling - in which case the default will be set to the
  bootstrap percentile method instead (\code{"perc"}).
}
\note{
All bootstrapped confidence intervals will tend to underestimate the
  true nominal coverage to some extent when sample size is small (Chernick &
  Labudde 2009), so the appropriate caution should be exercised in
  interpretation in such cases. Comparison of different interval types may be
  informative. For example, normal-theory based intervals may outperform
  bootstrap percentile methods when n < 34 (Hesterberg 2015). Ultimately
  however, the bootstrap is
  \href{https://stats.stackexchange.com/questions/112147/can-bootstrap-be-seen-as-a-cure-for-the-small-sample-size}{not
   a solution to small sample size}.
}
\examples{
## CI's from bootstrapped SEM
bootCI(Shipley.SEM.Boot)

## From original SEM (models)
## (not typically recommended - better to use saved boot objects)

\donttest{

system.time(
  Shipley.SEM.CI <- bootCI(Shipley.SEM, ran.eff = "site", seed = 53908,
                           ncpus = 2)
)
}
}
\references{
Chernick, M. R., & Labudde, R. A. (2009). Revisiting Qualms about
  Bootstrap Confidence Intervals. \emph{American Journal of Mathematical and
  Management Sciences}, \strong{29}(3–4), 437–456. \url{https://doi.org/c8zv}

  Efron, B. (1987). Better Bootstrap Confidence Intervals. \emph{Journal of
  the American Statistical Association}, \strong{82}(397), 171–185.
  \url{https://doi.org/gfww2z}

  Hesterberg, T. C. (2015). What Teachers Should Know About the Bootstrap:
  Resampling in the Undergraduate Statistics Curriculum. \emph{The American
  Statistician}, \strong{69}(4), 371–386. \url{https://doi.org/gd85v5}

  Puth, M.-T., Neuhäuser, M., & Ruxton, G. D. (2015). On the variety of
  methods for calculating confidence intervals by bootstrapping.
  \emph{Journal of Animal Ecology}, \strong{84}(4), 892–897.
  \url{https://doi.org/f8n9rq}
}
\seealso{
\code{\link[boot]{boot.ci}}, \code{\link[semEff]{bootEff}}
}
