% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_dashboard.R
\name{dashboard_header}
\alias{dashboard_header}
\alias{dashboardHeader}
\title{Create a header of a dashboard.}
\usage{
dashboard_header(
  ...,
  left = NULL,
  center = NULL,
  right = NULL,
  title = NULL,
  titleWidth = "thin",
  logo_align = "center",
  logo_path = "",
  color = "",
  inverted = FALSE,
  disable = FALSE,
  show_menu_button = TRUE,
  menu_button_label = "Menu",
  class = ""
)

dashboardHeader(
  ...,
  left = NULL,
  center = NULL,
  right = NULL,
  title = NULL,
  titleWidth = "thin",
  logo_align = "center",
  logo_path = "",
  color = "",
  inverted = FALSE,
  disable = FALSE,
  show_menu_button = TRUE,
  menu_button_label = "Menu",
  class = ""
)
}
\arguments{
\item{...}{UI elements to include within the header. They will be displayed on the right side.}

\item{left}{UI element to put on the left of the header. It will be placed after (to the right) the title and menu button (if they exist).}

\item{center}{UI element to put in the center of the header.}

\item{right}{UI element to put to the right of the header. It will be placed before elements defined in \code{...} (if there are any).}

\item{title}{Dashboard title to be displayed in the upper left corner. If NULL, will not display any title field. Use "" for an empty title.}

\item{titleWidth}{Title field width, one of \code{c(NULL, "very thin", "thin", "wide", "very wide")}}

\item{logo_align}{Where should logo be placed. One of \code{c("left", "center")}}

\item{logo_path}{Path or URL of the logo to be shown in the header.}

\item{color}{Color of the sidebar / text / icons (depending on the value of `inverted` parameter. \
One of \code{c("", "red", "orange", "yellow", "olive", "green", "teal", "blue", "violet", "purple", "pink", "brown", "grey", "black")}}

\item{inverted}{If FALSE sidebar will be white and text will be colored. \
If TRUE text will be white and background will be colored. Default is \code{FALSE}.}

\item{disable}{If \code{TRUE}, don't display the header.}

\item{show_menu_button}{If \code{FALSE}, don't display the menu button. Default is \code{TRUE}.}

\item{menu_button_label}{Text of the menu button. Default is \code{"Menu"}.}

\item{class}{CSS class to be applied to the container of \code{dashboardHeader}.}
}
\value{
A header that can be passed to \code{\link[semantic.dashboard]{dashboardPage}}
}
\description{
Create a header of a dashboard with other additional UI elements.
             Hint: use \code{shiny::tagList()} if you want to add multiple elements in \code{left} / \code{center} or \code{right}.
}
\section{Functions}{
\itemize{
\item \code{dashboardHeader}: Create a header of a dashboard (alias for \code{dashboard_header} for compatibility with \code{shinydashboard})
}}

\examples{
if(interactive()) {

  library(shiny)
  library(semantic.dashboard)

  ui <- dashboardPage(
    dashboardHeader(color = "blue", inverted = TRUE),
    dashboardSidebar(side = "left", size = "thin", color = "teal",
                     sidebarMenu(
                       menuItem(tabName = "tab1", "Tab 1"),
                       menuItem(tabName = "tab2", "Tab 2"))),
    dashboardBody(tabItems(
      tabItem(tabName = "tab1", p("Tab 1")),
      tabItem(tabName = "tab2", p("Tab 2"))))
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
}
