% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semaphore.r
\name{create_semaphore}
\alias{create_semaphore}
\alias{increment_semaphore}
\alias{decrement_semaphore}
\alias{remove_semaphore}
\title{Shared Memory Atomic Operations}
\usage{
create_semaphore(id = NULL, value = 0, cleanup = TRUE)

increment_semaphore(id)

decrement_semaphore(id, wait = TRUE)

remove_semaphore(id)
}
\arguments{
\item{id}{A semaphore identifier (string). \code{create_semaphore()}
defaults to generating a random identifier.}

\item{value}{The initial value of the semaphore.}

\item{cleanup}{Remove the semaphore when R session exits.}

\item{wait}{If \code{TRUE}, blocks until semaphore is greater than zero.}
}
\value{
\itemize{
\item \code{create_semaphore()} - The created semaphore's identifier (string), invisibly when \code{semaphore} is non-\code{NULL}.
\item \code{increment_semaphore()} - \code{TRUE}, invisibly.
\item \code{decrement_semaphore(wait = TRUE)} - \code{TRUE}, invisibly.
\item \code{decrement_semaphore(wait = FALSE)} - \code{TRUE} if the decrement was successful; \code{FALSE} otherwise.
\item \code{remove_semaphore()} - \code{TRUE} on success; \code{FALSE} on error.
}
}
\description{
A semaphore is an integer that the operating system keeps track of.
Any process that knows the semaphore's identifier can increment or
decrement its value, though it cannot be decremented below zero.\cr\cr
When the semaphore is zero, calling \code{decrement_semaphore(wait = FALSE)}
will return \code{FALSE} whereas \code{decrement_semaphore(wait = TRUE)} will
block until the semaphore is incremented by another process.
If multiple processes are blocked, a single call to \code{increment_semaphore()}
will only unblock one of the blocked processes.
}
\examples{

    library(semaphore) 
    
    s <- create_semaphore()
    print(s)
    
    increment_semaphore(s)
    decrement_semaphore(s, wait = FALSE)
    decrement_semaphore(s, wait = FALSE)
    
    remove_semaphore(s)
}
