% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_md_semfindr.R
\name{print.md_semfindr}
\alias{print.md_semfindr}
\title{Print a 'md_semfindr' Class Object}
\usage{
\method{print}{md_semfindr}(x, digits = 3, first = 10, sort = TRUE, decreasing = TRUE, ...)
}
\arguments{
\item{x}{An 'md_semfindr'-class object.}

\item{digits}{The number of digits after the decimal.
Default is 3.}

\item{first}{Numeric. If not \code{NULL}, it prints
only the first \emph{k} cases, \emph{k} equal to \code{first}.
Default is 10.}

\item{sort}{Logical. If \code{TRUE}, the default, the cases
will be sorted based on Mahalanobis distance.
The order is determined by \code{decreasing}.}

\item{decreasing}{Logical. Whether cases, if sorted,
is on decreasing order. Default is \code{TRUE}.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the content of a 'md_semfindr'-class object.
}
\details{
The print method for the
'md_semfindr'-class object, returned by
\code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}} or \code{\link[=mahalanobis_predictors]{mahalanobis_predictors()}}.
This method will print
the output with the option to sort the cases.
}
\examples{

library(lavaan)
dat <- pa_dat
# The model
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)
# Fit the model n times. Each time with one case removed.
# For illustration, do this only for selected cases.
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = 1:10)
# Compute the Mahalanobis distance for each case
out <- mahalanobis_rerun(fit_rerun)
out
print(out, first = 3)

}
\seealso{
\code{\link[=mahalanobis_rerun]{mahalanobis_rerun()}}, \code{\link[=mahalanobis_predictors]{mahalanobis_predictors()}}
}
