% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by_dvs.R
\name{group_estimates}
\alias{group_estimates}
\alias{group_by_dvs}
\alias{group_by_ivs}
\title{Group Estimates By Dependent
or Independent Variables}
\usage{
group_by_dvs(
  object,
  ...,
  col_name = "est",
  add_prefix = TRUE,
  group_first = FALSE,
  use_standardizedSolution = FALSE
)

group_by_ivs(
  object,
  ...,
  col_name = "est",
  add_prefix = TRUE,
  group_first = FALSE,
  use_standardizedSolution = FALSE
)
}
\arguments{
\item{object}{A \linkS4class{lavaan} object
or the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{...}{Optional arguments to be
passed to
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
Ignored if `object`` is an output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{col_name}{The column name of
information to be grouped. Default is
\code{"est"}. It accepts only one name.}

\item{add_prefix}{If \code{TRUE}, the
default, \code{col_name} will be added as
prefix to the column names of the
output.}

\item{group_first}{If \code{TRUE}, the
rows will be grouped by groups first
and then by independent variables
Ignored if the model has only one
group. Default is \code{FALSE}.}

\item{use_standardizedSolution}{If \code{TRUE}
and \code{object} is not an
estimates table,
then \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
will be used to generate the table.
If \code{FALSE}, the default, then
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} will
be used if necessary.}
}
\value{
A data-frame-like object of
the class \code{est_table}.
}
\description{
Groups parameter
estimates or other information such
as p-values into a table with
dependent variables as columns and
independent variables as rows, or a
transpose of this table.
}
\details{
It gets a \linkS4class{lavaan}
object or the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} and
group selected columns by "dependent"
variables \code{\link[=group_by_dvs]{group_by_dvs()}} or by
"independent" variables
\code{\link[=group_by_ivs]{group_by_ivs()}}.

"Dependent" variables are defined
as variables on the left hand side
of the operator \code{~}.

"Independent" variables are defined
as variables on the right hand side
of the operator \code{~}.

Note that a variable can both be
a "dependent" variable and an
"independent" variable in a model.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

fit <- sem(model, data = dat, fixed.x = FALSE)
parameterEstimates(fit)

# Group by DVs
group_by_dvs(fit)

# Group by IVs
group_by_ivs(fit)

}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
