% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_constructs.R
\name{composite}
\alias{composite}
\title{Composite construct measurement model specification}
\usage{
composite(construct_name, item_names,weights = correlation_weights)
}
\arguments{
\item{construct_name}{of construct}

\item{item_names}{returned by the \code{multi_items} or \code{single_item} functions}

\item{weights}{is the relationship between the construct and its items. This can be
specified as \code{correlation_weights} or \code{mode_A} for correlation weights (Mode A) or as
\code{regression_weights} or \code{mode_B} for regression weights (Mode B). Default is correlation weights.}
}
\description{
\code{composite} creates the composite measurement model matrix for a specific construct,
specifying the relevant items of the construct and assigning the relationship of either
correlation weights (Mode A) or regression weights (Mode B).
}
\details{
This function conveniently maps composite defined measurement items to a construct and is
estimated using PLS.
}
\examples{
  mobi_mm <- constructs(
    composite("Image",        multi_items("IMAG", 1:5), weights = correlation_weights),
    composite("Expectation",  multi_items("CUEX", 1:3), weights = mode_A),
    composite("Quality",      multi_items("PERQ", 1:7), weights = regression_weights),
    composite("Value",        multi_items("PERV", 1:2), weights = mode_B)
  )
}
\seealso{
See \code{\link{constructs}}, \code{\link{reflective}}
}
