% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_htmt.R
\name{dot_graph_htmt}
\alias{dot_graph_htmt}
\title{Creates a dot string with a network graph of constructs based on HTMT measures}
\usage{
dot_graph_htmt(
  model,
  title = "HTMT Plot",
  theme = seminr::seminr_theme_get(),
  htmt_threshold = 1,
  omit_threshold_edges = T,
  use_ci = FALSE
)
}
\arguments{
\item{model}{A bootsrapped PLS-Model}

\item{title}{Optional title over the plot.}

\item{theme}{Optional theme to use for plotting}

\item{htmt_threshold}{The threshold to use under which constructs are highlighted (default = 1.0)}

\item{omit_threshold_edges}{Whether or not to omit constructs that have low HTMT values (default = TRUE)}

\item{use_ci}{Whether or not to rely on the upper threshold of the CI instead of the bootstrapped mean (default = FALSE)}
}
\value{
Returs a dot string of the plot
}
\description{
Using a bootstrapped model this functions shows which constructs show
insufficient discriminant validity.
}
