% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_constructs.R
\name{reflective}
\alias{reflective}
\title{Reflective construct measurement model specification}
\usage{
reflective(construct_name, item_names)
}
\arguments{
\item{construct_name}{of construct}

\item{item_names}{returned by the \code{multi_items} or \code{single_item} functions}
}
\value{
A vector of the indicators for a reflective construct.
}
\description{
\code{reflective} creates the reflective measurement model matrix for a specific common-factor,
specifying the relevant items of the construct and assigning the relationship of reflective.
By definition this construct will be estimated by PLS consistent.
}
\details{
This function conveniently maps reflectively defined measurement items to a construct and is estimated
using PLS consistent.
}
\examples{
  mobi_mm <- constructs(
    reflective("Image",        multi_items("IMAG", 1:5)),
    reflective("Expectation",  multi_items("CUEX", 1:3)),
    reflective("Quality",      multi_items("PERQ", 1:7)),
    reflective("Value",        multi_items("PERV", 1:2)),
    reflective("Satisfaction", multi_items("CUSA", 1:3)),
    reflective("Complaints",   single_item("CUSCO")),
    reflective("Loyalty",      multi_items("CUSL", 1:3))
  )
}
\seealso{
See \code{\link{composite}}, \code{\link{constructs}}
}
