% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_object.R
\name{add_object}
\alias{add_object}
\title{Add a Fit Object to a 'qgraph'
Object}
\usage{
add_object(semPaths_plot, object)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}, or a similar
\link[qgraph:qgraph]{qgraph::qgraph} object modified by
other \link{semptools} functions.}

\item{object}{Should be the object,
such as the output of \code{\link[lavaan:sem]{lavaan::sem()}}
or \code{\link[lavaan:cfa]{lavaan::cfa()}}, used by
\code{\link[semPlot:semPaths]{semPlot::semPaths()}} to generate
\code{semPaths_plot}. Note that this
function will not check whether
the object is appropriate because
there is no way to do so reliably.}
}
\value{
The original \link[qgraph:qgraph]{qgraph::qgraph} object
set to \code{semPaths_plot}, with the
attribute \code{"semptools_fit_object"}
set to \code{object}.
}
\description{
Add a fit object (e.g.,
'lavaan' output) to the a 'qgraph'
object as an attribute.
}
\details{
It adds an object to
a \link[qgraph:qgraph]{qgraph::qgraph} object as the
attribute \code{"semptools_fit_object"},
to be retrieved by other functions
that need to access the original
output used in \code{\link[semPlot:semPaths]{semPlot::semPaths()}}
to create a diagram.
}
\examples{

library(lavaan)
library(semPlot)

mod <-
  'f1 =~ x01 + x02 + x03 + x06
   f2 =~ x04 + x05 + x06 + x07
   f3 =~ x08 + x09 + x10 + x03
   f4 =~ x11 + x12 + x13 + x14
  '
fit <- lavaan::cfa(mod, cfa_example)
p <- semPaths(fit,
              whatLabels = "est",
              sizeMan = 3.25,
              node.width = 1,
              edge.label.cex = .75,
              mar = c(10, 5, 10, 5),
              DoNotPlot = TRUE)
p <- add_object(p, fit)
attr(p, "semptools_fit_object")

}
\seealso{
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}
}
