% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune}
\alias{prune}
\alias{prune.semtree}
\alias{prune.semforest}
\title{Prune a SEM Tree or SEM Forest}
\usage{
prune(object, ...)
}
\arguments{
\item{object}{A \code{\link{semtree}} or semforest object.}

\item{\dots}{Optional parameters, such as \code{max.depth} the maximum depth
of each tree, or also \code{num.trees} when pruning a forest.}
}
\value{
Returns a \code{\link{semtree}} object.
}
\description{
Returns a new tree with a maximum depth selected by the user. can be used in
conjunction with plot commands to view various pruning levels.
}
\details{
The returned tree is only modified by the number of levels for the tree.
This function does not reevaluate the data, but provides alternatives to
reduce tree complexity. If the user would like to alter the tree by
increasing depth, then max.depth option must be adjusted in the
\code{\link{semtree.control}} object (provided further splits are able to be
computed).
}
\references{
Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
U. (2013). Structural equation model trees. \emph{Psychological Methods},
18(1), 71-86.
}
\seealso{
\code{\link{semtree}}, \code{\link{semtree.control}}
}
\author{
Andreas M. Brandmaier, John J. Prindle
}
