% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{proximity}
\alias{proximity}
\alias{plot.proximity}
\alias{plot.semforest.proximity}
\title{SEM Forest Case Proximity}
\usage{
proximity(forest, dataset = NULL, type = 0, aggregate = T, ...)
}
\arguments{
\item{forest}{A \code{\link{semforest}} object.}

\item{dataset}{A dataset to compute proximity values for.}

\item{type}{Missingness accounted for. (0 = no, 1 = yes)}

\item{aggregate}{Boolean marker to compute aggregate proximity scores.}

\item{\dots}{Optional arguments.}
}
\value{
A matrix with dimensions NxN is returned. The values of each cell
are bounded (0,1) and represent proportion of trees where each case are in
the same leaf nodes.
}
\description{
A \code{\link{semforest}} process to represent proportion of trees where
each case are in the same leaf nodes. The values are bounded (0,1), where
higher values are closer in proximity.
}
\references{
Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
U. (2013). Structural equation model trees. \emph{Psychological Methods},
18(1), 71-86.
}
\seealso{
\code{\link{semforest}}, \code{\link{semtree}}
}
\author{
Andreas M. Brandmaier, John J. Prindle
}
