% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen2cor.R
\name{sen2cor}
\alias{sen2cor}
\title{Correct L1C products using Sen2Cor}
\usage{
sen2cor(l1c_prodlist = NULL, l1c_dir = NULL, outdir = NULL,
  proc_dir = NA, tmpdir = NA, rmtmp = TRUE, tiles = NULL,
  parallel = FALSE, overwrite = FALSE, .log_message = NA,
  .log_output = NA)
}
\arguments{
\item{l1c_prodlist}{List of L1C product names to be corrected. They can be both
product names with full/relative path or only names of SAFE products (in this case, also
l1c_dir argument must be provided). SAFE products must be unzipped.
Note that, at this stage, all products must be in the same directory (this will be fixed).}

\item{l1c_dir}{Full or relative path of input L1C products.
If NULL (default), \code{l1c_prodlist} must already be a vector of full paths.}

\item{outdir}{Directory where output L2A products will be placed.
If NULL (default), each product is left in the parent directory of \code{l1c_prodlist}.}

\item{proc_dir}{(optional) Directory where processing is applied.
If NA (default), processing is done in \code{l1c_dir} and output L2A product is
then moved to \code{outdir}, unless \code{l1c_dir} is a subdirectory of a SAMBA mountpoint under Linux:
in this case, L1C input products are copied in a temporary directory
(specified with argument \code{tmpdir}),
processing is done there and then L2A is moved to \code{outdir}.
This is required under Linux systems when \code{l1c_dir} is a subdirectory of
a unit mounted with SAMBA, otherwise Sen2Cor would produce empty L2A products.}

\item{tmpdir}{(optional) Path where processing is performed if a temporary
working directory is required (see argument \code{proc_dir}). Be sure \code{tmpdir}
not to be a SAMBA mountpoint under Linux.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}

\item{rmtmp}{(optional) Logical: should temporary files be removed?
(Default: TRUE)}

\item{tiles}{Vector of Sentinel-2 Tile strings (5-length character) to be
processed (default: process all the tiles found in the input L1C products).}

\item{parallel}{(optional) Logical: if TRUE, Sen2Cor instances are launched
in parallel using multiple cores; if FALSE (default), they are launched in
series on a single core.
The number of cores is automatically determined; specifying it is also
possible (e.g. \code{parallel = 4}).}

\item{overwrite}{Logical value: should existing output L2A products be overwritten?
(default: FALSE)}

\item{.log_message}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}

\item{.log_output}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}
}
\value{
Vector character with the list ot the output products (being corrected or already
existing)
}
\description{
The function uses Sen2Cor to manually correct L1C products.
Standalone version of
\href{http://step.esa.int/main/third-party-plugins-2/sen2cor}{sen2cor}
(version 2.8.0 or 2.5.5) is used.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
pos <- st_sfc(st_point(c(12.0, 44.8)), crs=st_crs(4326))
time_window <- as.Date(c("2017-05-01","2017-07-30"))
example_s2_list <- s2_list(spatial_extent=pos, tile="32TQQ", time_interval=time_window)
s2_download(example_s2_list, outdir=tempdir())
sen2cor(names(example_s2_list)[1], l1c_dir=tempdir(), outdir=tempdir())
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
