% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_calcindices.R
\name{s2_calcindices}
\alias{s2_calcindices}
\title{Compute maps of spectral indices}
\usage{
s2_calcindices(
  infiles,
  indices,
  outdir = ".",
  parameters = NULL,
  source = c("TOA", "BOA"),
  format = NA,
  subdirs = NA,
  tmpdir = NA,
  compress = "DEFLATE",
  bigtiff = FALSE,
  dataType = "Int16",
  scaleFactor = NA,
  proc_mode = "raster",
  parallel = FALSE,
  overwrite = FALSE,
  .log_message = NA,
  .log_output = NA
)
}
\arguments{
\item{infiles}{A vector of input filenames. Input files are paths
of BOA (or TOA) products already converted from SAFE format to a
format managed by GDAL (use \link{s2_translate} to do it);
their names must be in the sen2r naming convention
(\link{safe_shortname}).}

\item{indices}{Character vector with the names of the required
indices. Values should be included in names corresponding to the
Abbreviations of the following indices:
\href{https://www.indexdatabase.de/db/is.php?sensor_id=96}{IDB}.}

\item{outdir}{(optional) Full name of the output directory where
the files should be created (default: current directory).
\code{outdir} can bot be an existing or non-existing directory (in the
second case, its parent directory must exists).
If it is a relative path, it is expanded from the common parent
directory of \code{infiles}.}

\item{parameters}{(optional) Values of index parameters. This variable
must be a named list, in which each element is a list of parameters,
i.e.:
\code{parameters = list("SAVI" = list("a" = 0.5))}
Values can be both numeric values or band names (e.g. "band_1").
If not specified, parameters are set to default values.}

\item{source}{(optional) Vector with the products from which computing
the indices. It can be \code{"BOA"}, \code{"TOA"} or both (default). If both values
are provided, indices are computed from the available products (\code{"TOA"}
if TOA is available, BOA if BOA is available); in the case both are
available, two files are produced (they can be distinguished from the
level component - S2x1C or S2x2A - in the filename).}

\item{format}{(optional) Format of the output file (in a
format recognised by GDAL). Default is the same format of input images
(or "GTiff" in case of VRT input images).}

\item{subdirs}{(optional) Logical: if TRUE, different indices are
placed in separated \code{outfile} subdirectories; if FALSE, they are placed in
\code{outfile} directory; if NA (default), subdirectories are created only if
more than a single spectral index is required.}

\item{tmpdir}{(optional) Path where intermediate files (GTiff) will be
created in case \code{format} is \code{"VRT"}.}

\item{compress}{(optional) In the case a GTiff format is
present, the compression indicated with this parameter is used.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{dataType}{(optional) Numeric datatype of the output rasters.
if "Float32" or "Float64" is chosen, numeric values are not rescaled;
if \code{"Int16"} (default) or \code{"UInt16"}, values are multiplicated by \code{scaleFactor} argument;
if \code{"Byte"}, values are shifted by 100, multiplicated by 100 and truncated
at 200 (so that range -1 to 1 is coerced to 0-200), and nodata value
is assigned to 255.}

\item{scaleFactor}{(optional) Scale factor for output values when an integer
datatype is chosen (default values are 10000 for \code{"Int16"} and \code{"UInt16"},
1E9 for \code{"Int32"} and \code{"UInt32"}). Notice that, using \code{"UInt16"} and
\code{"UInt32"} types, negative values will be truncated to 0.}

\item{proc_mode}{(optional) Character: if \code{"gdal_calc"},
\code{gdal_calc} routines are used to compute indices;
if \code{"raster"} (default) or \code{"stars"}, R functions are instead used
(using respectively \code{raster} or \code{stars} routines).
\strong{Notes}:
\enumerate{
\item default value (\code{"raster"}) is the only fully supported mode.
\code{"gdal_calc"} can be used only if a runtime GDAL environment can be properly
configured (no assistance is provided in case of GDAL-related problems).
\code{"raster"} mode is experimental.
\item There is a difference in which the two modes manage values out
of ranges (e.g. -32768 to 32767 in Int16 and 0 to 255 in Byte):
\code{"raster"} and \code{"stars"} modes set these values to NA,
\code{"gdal_calc"} mode clip them to the minimum/maximum values;
}}

\item{parallel}{(optional) Logical: if TRUE, the function is run using parallel
processing, to speed-up the computation for large rasters.
The number of cores is automatically determined; specifying it is also
possible (e.g. \code{parallel = 4}).
If FALSE (default), single core processing is used.
Multiprocess masking computation is always performed in singlecore mode}

\item{overwrite}{Logical value: should existing output files be
overwritten? (default: FALSE)}

\item{.log_message}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}

\item{.log_output}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}
}
\value{
A vector with the names of the created products.
}
\description{
Create maps of a set of spectral indices. Since
\code{gdal_calc.py} is used to perform computations, output files
are physical rasters (no output VRT is allowed).
}
\note{
License: GPL 3.0
}
\examples{
# Define file names
ex_in <- system.file(
  "extdata/out/S2A2A_20190723_022_Barbellino_BOA_10.tif",
  package = "sen2r"
)

# Run function
ex_out <- s2_calcindices(
  infiles = ex_in,
  indices = "EVI",
  outdir = tempdir(),
  dataType = "Float32"
)
ex_out

# Show output
oldpar <- par(mfrow = c(1,2), mar = rep(0,4))
image(stars::read_stars(ex_in), rgb = 4:2, maxColorValue = 3500)
par(mar = rep(2/3,4)); image(stars::read_stars(ex_out))
par(oldpar)
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
