% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comsub.R
\name{comsub}
\alias{comsub}
\title{Find the longest common starting substring or directory}
\usage{
comsub(data, sep = "")
}
\arguments{
\item{data}{A vector of strings}

\item{sep}{A character which is used to separate elements; default ("")
is used to compare single characters; other useful alternatives are
"/" (or "\\\\\\\\" in Windows) to find the longest common directory, or
" " to compare words instead of characters.}
}
\value{
A character with the longest common initial substring
}
\description{
The function search for the longest common prefix between
multiple strings.
}
\note{
Modified from a suggestion taken from
\href{https://stackoverflow.com/questions/28273716/r-implementation-for-finding-the-longest-common-starting-substrings-in-a-set-of}{stackoverflow}.
}
\examples{
strings <- c("/home/user/git/sen2r",
             "/home/user/git_data/sen2r/ex/vrt/01_translate/")

comsub(strings)

comsub(strings, sep="/")
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
