% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_dop.R
\name{s2_dop}
\alias{s2_dop}
\title{Return the Dates Of Passage over some orbits}
\usage{
s2_dop(s2_orbits = 1:143, timewindow = "10 days", mission = c("2A", "2B"))
}
\arguments{
\item{s2_orbits}{A vector of Sentinel-2 orbits (as integer numbers
or 3-length character).
Default is all the 143 orbits.}

\item{timewindow}{Temporal window for querying: Date object
of length 1 (single day) or 2 (time window).
Is it possible to pass also integer (or difftime) values, which are
interpreted as the next n days (if positive) or the past n days
(if negative).
Also strings which can be interpreted as time ranges are accepted
(see examples).
Default is the next 10 days (one cycle).}

\item{mission}{(optional) Vector with the desired Sentinel-2 missions
("2A", "2B" or both). Default is both.}
}
\value{
A data table with the dates (column "date"), the missions
(column "mission") and the orbits (column "orbit").
An empty data table with the same structure is returned if no passages
were found with the passed settings.
}
\description{
The function allows to know which Sentinel-2 passages should
pass over certain orbits during a defined time interval.
Dates are intended to be in UTC time.
Notice that this is the expected calendar: some unexpected events
(e.g. technical problems, or early working phases during first stages of
acquisition) could cause the data unavailability even if an
acquisition was expected.
Notice also that some orbits (030, 073 and 116) acquire across UTC midnight:
in this cases, the date is assumed to be the one of the acquisition after
midnight (which corresponds to the date in local time).
}
\note{
License: GPL 3.0
}
\examples{
# All the passages in a cycle of 10 days over all the orbits
s2_dop()

# The passages in the current month over two orbits
s2_dop(c("022", "065"), "this month")

# The dates in which Sentinel-2A will pass in next six weeks over one orbit
s2_dop("022", "6 weeks", mission = "2A")$date

# The date in which Sentinel-2A would be passed in the last 10 days over one orbit
s2_dop("022", "-10 days", mission = "2A")$date

# All the orbits covered today
s2_dop(timewindow = Sys.Date(), mission = "2B")$orbit

# The passages in a fixed time window for one orbit
s2_dop(65, as.Date(c("2018-08-01", "2018-08-31")))

# A research with no passages found
s2_dop(22, "2018-08-16", mission = "2A")
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019)
}
