% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{metafunction}
\alias{metafunction}
\title{Random metafunction based on \insertCite{Becker2020;textual}{sensobol}'s metafunction.}
\usage{
metafunction(data, k_2 = 0.5, k_3 = 0.2, epsilon = NULL)
}
\arguments{
\item{data}{A numeric matrix where each column is a model input and each row a sampling point.}

\item{k_2}{Numeric value indicating the fraction of active pairwise interactions (between 0 and 1).
Default is \code{k_2 = 0.5}.}

\item{k_3}{Numeric value indicating the fraction of active three-wise interactions
(between 0 and 1). Default is \code{k_2 = 0.2}.}

\item{epsilon}{Integer value. It fixes the seed for the random number generator.
The default is \code{epsilon = NULL}.}
}
\value{
A numeric vector with the function output.
}
\description{
Random metafunction based on \insertCite{Becker2020;textual}{sensobol}'s metafunction.
}
\details{
The metafunction randomly combines the following functions in a metafunction of dimension \eqn{k}:
\itemize{
\item \eqn{f(x) = x ^ 3} (cubic).
\item \eqn{f(x) = 1~\mbox{if}(x > 0.5), 0~\mbox{otherwise}} (discontinuous).
\item \eqn{f(x) = \frac{e ^ x}{e - 1}} (exponential).
\item \eqn{f(x) = \frac{10 - 1}{1.1} ^ {-1} (x + 0.1) ^ {-1}} (inverse).
\item \eqn{f(x) = x} (linear)
\item \eqn{f(x) = 0} (no effect).
\item \eqn{f(x) = 4(x - 0.5) ^  2} (non-monotonic).
\item \eqn{f(x) = \frac{\sin (2 \pi x)}{2}} (periodic).
\item \eqn{f(x) = x ^ 2} (quadratic).
\item \eqn{f(x) = \cos(x)} (trigonometric).
}

It is constructed as follows:

\deqn{y=\sum_{i=1}^{k}\alpha_i f^{u_i}(x_i) \\
 + \sum_{i=1}^{k_2}\beta_i f^{u_{V_{i,1}}}(x_{V_{i,1}}) f^{u_{V_{i,2}}} (x_{V_{i,2}}) \\
+ \sum_{i=1}^{k_3}\gamma_i f^{u_{W_{i,1}}}(x_{W_{i,1}}) f^{u_{W_{i,2}}}(x_{W_{i,2}}) f^{u_{W_{i,3}}} (x_{W_{i,3}})}

where \eqn{k} is the model dimensionality, \eqn{u} is a \eqn{k}-length vector formed by randomly
sampling with replacement the ten functions mentioned above, \eqn{V} and \eqn{W} are two matrices specifying the
number of pairwise and three-wise interactions given the model dimensionality,
and \eqn{\mathbf{\alpha}, \mathbf{\beta}, \mathbf{\gamma}} are three
vectors of length \eqn{k} generated by sampling from a mixture of two normal distributions
\eqn{\Psi=0.3\mathcal{N}(0, 5) + 0.7\mathcal{N}(0, 0.5)}.
See \insertCite{Puyj;textual}{sensobol} and \insertCite{Becker2020;textual}{sensobol} for a full
mathematical description of the metafunction approach.
}
\examples{
# Define settings (number of model inputs = 86)
N <- 100; params <- paste("X", 1:86, sep = "")

# Create sample matrix
mat <- sobol_matrices(N = N, params = params)

# Compute metafunction
Y <- metafunction(mat)
}
\references{
\insertAllCited{}
}
