% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{diff.sentomeasures}
\alias{diff.sentomeasures}
\title{Differencing of sentiment measures}
\usage{
\method{diff}{sentomeasures}(x, lag = 1, differences = 1, ...)
}
\arguments{
\item{x}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{lag}{a \code{numeric}, see documentation for the generic \code{\link{diff}}.}

\item{differences}{a \code{numeric}, see documentation for the generic \code{\link{diff}}.}

\item{...}{not used.}
}
\value{
A modified \code{sentomeasures} object, with the measures replaced by the differenced measures as well as updated
statistics.
}
\description{
Differences the sentiment measures from a \code{sentomeasures} object.
}
\examples{
data("usnews", package = "sentometrics")
data("lexicons", package = "sentometrics")
data("valence", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# first-order difference sentiment measures with a lag of two
diffed <- diff(sentomeasures, lag = 2, differences = 1)

}
\author{
Samuel Borms
}
