% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribution.R
\name{attributions}
\alias{attributions}
\title{Retrieve top-down model sentiment attributions}
\usage{
attributions(model, sentomeasures, do.normalize = FALSE,
  refDates = NULL, factor = NULL)
}
\arguments{
\item{model}{a \code{sentomodel} or \code{sentomodeliter} object created with \code{\link{sento_model}}.}

\item{sentomeasures}{the \code{sentomeasures} object, as created with \code{\link{sento_measures}}, used to estimate
the model from the first argument.}

\item{do.normalize}{a \code{logical}, \code{TRUE} divides each element of every attribution vector at a given date by its
L2-norm at that date, normalizing the values between -1 and 1. The document attributions are not normalized.}

\item{refDates}{the dates (as \code{"yyyy-mm-dd"}) at which attribution is to be performed. These should be between the latest
date available in the input \code{sentomeasures} object and the first estimation sample date (that is, \code{model$dates[1]}
if \code{model} is a \code{sentomodel} object). All dates should also be in \code{get_dates(sentomeasures)}. If
\code{NULL} (default), attribution is calculated for all in-sample dates. Ignored if \code{model} is a \code{sentomodeliter}
object, for which attribution is calculated for all out-of-sample prediction dates.}

\item{factor}{the factor level as a single \code{character} vector for which attribution has to be calculated in
case of (a) multinomial model(s). Ignored for linear and binomial models.}
}
\value{
A \code{list} of class \code{attributions}, with \code{"documents"}, \code{"lags"}, \code{"lexicons"},
\code{"features"} and \code{"time"} as dimensions for which aggregation is computed. The last four dimensions are
\code{data.table}s having a \code{"date"} column and the other columns the different components of the dimension, with the
attributions as values. Document-level attribution is further decomposed into a \code{data.table} per date, with
\code{"id"}, \code{"date"} and \code{"attrib"} columns.
}
\description{
Computes the attributions to predictions for a (given) number of dates at all possible sentiment dimensions,
based on the coefficients associated to each sentiment measure, as estimated in the provided model object.
}
\details{
See \code{\link{sento_model}} for an elaborate modelling example including the calculation and plotting of
attributions. The attribution for logistic models is represented in terms of log odds. For binomial models, it is
calculated with respect to the last factor level or factor column. A \code{NULL} value for document-level attribution
on a given date means that no documents are (directly) implicated for the associated prediction.
}
\seealso{
\code{\link{sento_model}}
}
\author{
Samuel Borms, Keven Bluteau
}
