% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.sentopicmodel}
\alias{plot.sentopicmodel}
\title{Plot a topic model using Plotly}
\usage{
\method{plot}{sentopicmodel}(x, nWords = 15, layers = 3, sort = FALSE, ...)
}
\arguments{
\item{x}{a model created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}} function and
estimated with \code{\link[=fit]{fit()}}}

\item{nWords}{the number of words per topic/sentiment to display in the outer
layer of the plot}

\item{layers}{specifies the number of layers for the sunburst chart. This
will restrict the output to the \code{layers} uppermost levels of the chart. For
example, setting \code{layers = 1} will only display the top level of the
hierarchy (topics for an LDA model).}

\item{sort}{if \code{TRUE}, sorts the plotted topics in a decreasing frequency.}

\item{...}{not used}
}
\value{
A \code{plotly} sunburst chart.
}
\description{
Summarize and plot a \strong{sentopics} model using a sunburst chart
from the \link[plotly:plotly]{plotly::plotly} library.
}
\examples{
lda <- LDA(ECB_press_conferences_tokens)
lda <- fit(lda, 100)
plot(lda, nWords = 5)

# only displays the topic proportions
plot(lda, layers = 1)
}
\seealso{
\code{\link[=topWords]{topWords()}} \code{\link[=LDAvis]{LDAvis()}}
}
