% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPstats.R
\name{OHperSNP}
\alias{OHperSNP}
\title{Estimate Genotyping Error Rate}
\usage{
OHperSNP(GenoM, Par, Dups = NULL)
}
\arguments{
\item{GenoM}{genotype matrix, in sequoia's format: 1 column per SNP, 1 row
per individual, genotypes coded as 0/1/2/-9, and rownames giving individual
IDs.}

\item{Par}{pedigree dataframe, only genotyped parents are used.}

\item{Dups}{pairs of duplicates}
}
\value{
A dataframe with columns:
\item{n.dam, n.sire, n.pair}{Number of dams, sires, parent-pairs successfully
  genotyped for the SNP}
\item{OHdam, OHsire}{Count of number of opposing homozygous cases}
\item{MEpair}{Count of Mendelian errors, includes opposing homozygous cases}
\item{n.dups, n.diff}{Number of duplicate pairs successfully genotyped for
  the SNP; number of differences}
}
\description{
Estimate genotyping error rate from Mendelian errors per SNP.
}
\seealso{
\code{\link{SnpStats}}.
}
\keyword{internal}
