% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{lindstrom_madden_AC}
\alias{lindstrom_madden_AC}
\title{Lindstrom and Madden's method with Agresti-Coull}
\usage{
lindstrom_madden_AC(s, n, alpha, ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound.
}
\description{
Calculate a binomial series lower confidence bound using Agresti-Coull (1998) lower confidence bound calculation in the Lindstrom and Madden's (1962) method.
}
\examples{
lindstrom_madden_AC(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10)
}
