% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVoigtIBIS.R
\name{fitVoigtIBIS}
\alias{fitVoigtIBIS}
\title{Fit the model with Voigt peaks using iterated batch importance sampling (IBIS).}
\usage{
fitVoigtIBIS(
  wl,
  spc,
  n,
  lResult,
  conc = rep(1, nrow(spc)),
  batch = rep(1, nrow(spc)),
  npart = 10000,
  rate = 0.9,
  mcAR = 0.23,
  mcSteps = 10,
  minESS = npart/2,
  destDir = NA
)
}
\arguments{
\item{wl}{Vector of \code{nwl} wavenumbers at which the spetra are observed.}

\item{spc}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{n}{index of the new observation}

\item{lResult}{List of results from the previous call to ``fitVoigtPeaksSMC`` or ``fitVoigtIBIS``}

\item{conc}{Vector of \code{n_y} nanomolar (nM) dye concentrations for each observation.}

\item{batch}{identifies to which batch each observation belongs}

\item{npart}{number of SMC particles to use for the importance sampling distribution.}

\item{rate}{the target rate of reduction in the effective sample size (ESS).}

\item{mcAR}{target acceptance rate for the MCMC kernel}

\item{mcSteps}{number of iterations of the MCMC kernel}

\item{minESS}{minimum effective sample size, below which the particles are resampled.}

\item{destDir}{destination directory to save intermediate results (for long-running computations)}
}
\description{
Fit the model with Voigt peaks using iterated batch importance sampling (IBIS).
}
\references{
Chopin (2002) "A Sequential Particle Filter Method for Static Models," Biometrika 89(3): 539--551,
\doi{10.1093/biomet/89.3.539}
}
