% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{read_from_gd}
\alias{read_from_gd}
\title{Read from Google Drive a JSON file inside rstudio folder}
\usage{
read_from_gd(what, progBar = NULL)
}
\arguments{
\item{what}{One of c("rstudio_bindings", "editor_bindings", "addins"),
the file to read}

\item{progBar}{function, designed to work with [progress_bar()]. Runs after
the file is read.}
}
\value{
A data frame with the contents of the file, converted from json
}
\description{
This is a helper function for [pull()] and [sync()] that:
* reads a json file from Google Drive inside the rstudio folder
* converts it to a data frame (to resolve conflicts in the future)
}
\examples{
mimic_on()
  read_from_gd("rstudio_bindings")
  read_from_gd("editor_bindings")
  read_from_gd("addins")
mimic_off()
}
\seealso{
[read_from_local()] [sync()]
[jsonlite::fromJSON()] [googledrive::drive_read_string()]
}
