% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights-inverse-distance.R
\name{st_inverse_distance}
\alias{st_inverse_distance}
\title{Calculate inverse distance weights}
\usage{
st_inverse_distance(nb, geometry, scale = 100, alpha = 1)
}
\arguments{
\item{nb}{a neighbors list object e.g. created by \code{\link[=st_knn]{st_knn()}} or \code{\link[=st_contiguity]{st_contiguity()}}}

\item{geometry}{sf geometry}

\item{scale}{default \code{100}.a value to scale distances by before exponentiating by \code{alpha}}

\item{alpha}{default 1. Set to 2 for gravity weights.}
}
\value{
a list where each element is a numeric vector
}
\description{
From a neighbor list and sf geometry column, calculate inverse distance weight.
}
\details{
The inverse distance formula is
\eqn{w_{ij} = 1 / d_{ij}^\alpha}
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wts <- st_inverse_distance(nb, geo)
head(wts, 3)
wts <- st_inverse_distance(nb, geo, scale = 10000)
head(wts, 3)
}
\seealso{
Other weights: 
\code{\link{st_kernel_weights}()},
\code{\link{st_nb_dists}()},
\code{\link{st_weights}()}
}
\concept{weights}
