% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{sf_to_df}
\alias{sf_to_df}
\title{sf to df}
\usage{
sf_to_df(sf, fill = FALSE)
}
\arguments{
\item{sf}{sf object}

\item{fill}{logical indicating if the resulting data.frame should be filled
with the data columns from the sf object. If \code{TRUE}, each row of data will
be replicated for every coordiante in every geometry.}
}
\description{
Converts an sf object ot a data.frame
}
\examples{

df <- data.frame(
ml_id = c(1,1,1,1,1,1,1,1,1,2,2,2,2,2,2)
, l_id = c(1,1,1,2,2,2,3,3,3,1,1,1,2,2,2)
, x = rnorm(15)
, y = rnorm(15)
, z = rnorm(15)
, m = rnorm(15)
)

sf <- sf_polygon( obj = df, polygon_id = "ml_id", linestring_id = "l_id" )
df <- sf_to_df( sf )

## with associated ata
sf$val1 <- c("a","b")
sf$val2 <- c(1L, 2L)

df <- sf_to_df( sf, fill = TRUE )

}
