\name{fit.variogram}
\title{Variogram Model Fit}
\usage{
fit.variogram(model="exponential", v.object, nugget, sill,
              range, slope, ...)
fit.exponential(v.object, c0, ce, ae, type='c', 
                iterations=10, tolerance=1e-06, echo=F, plot.it=F, weighted=T)
fit.gaussian(v.object, c0, cg, ag, type='c', 
             iterations=10, tolerance=1e-06, echo=F,  plot.it=F, weighted=T)
fit.spherical(v.object, c0, cs, as, type='c', iterations=10,
             tolerance=1e-06, echo=F,  plot.it=F, weighted=T, delta=0.1)
fit.wave(v.object, c0, cw, aw, type='c', 
         iterations=10, tolerance=1e-06, echo=F,  plot.it=F, weighted=T)
fit.linear(v.object, type='c', plot.it=F,iterations=1, c0=0, cl=1)}
\alias{fit.variogram}
\alias{fit.exponential}
\alias{fit.wave}
\alias{fit.gaussian}
\alias{fit.spherical}
\alias{fit.linear}
\arguments{
\item{model}{only available for \code{fit.variogram}, switches what kind
  of model should be fitted (\code{"exponential", "wave", "gaussian",
  "spherical", "linear"}).}
\item{v.object}{a variogram object generated by \code{est.variogram()}}
\item{nugget, sill, range, slope}{only available for \code{fit.variogram},
  initial estimates for specified variogram model (\code{slope} only for
  \code{fit.linear})}
\item{c0}{initial estimate for nugget effect, valid for all variogram
  types, partial sill (\code{cX}) and (asymptotical) range (\code{aX})
  as follows:}
\item{ce, ae}{initial estimates for the exponential variogram model}
\item{cg, ag}{initial estimates for the gaussian variogram model}
\item{cs, as}{initial estimates for the sperical variogram model}
\item{cw, aw}{initial estimates for the periodical variogram model}
\item{cl}{initial estimates for the linear variogram model (slope)}
\item{type}{one of \code{'c'} (classic), \code{'r'} (robust), \code{'m'} (median). Indicates to which type of empirical variogram estimate the model is
to be fit.}
\item{iterations}{the number of iterations of the fitting procedure to execute.}
\item{tolerance}{the tolerance used to determine if model convergence has been achieved.}
\item{delta}{initial stepsize (relative) for pseudo Newton approximation, applies only to \code{fit.spherical}}
\item{echo}{if T, be verbose.}
\item{plot.it}{if T, the variogram estimate will be plotted each iteration.}
\item{weighted}{if T, the fit will be done using weighted least squares,
  where the weightes are given in Cressie (1991, p. 99)}
\item{...}{only \code{fit.variogram}: additional parameters to hand
  through to specific model fit functions}
}
\value{A variogram.model object:
\item{parameters}{vector of fitted model parameters}
\item{model}{function implementing a valid variogram model}
}
\description{Fit variogram models (exponential, spherical, gaussian, linear) to empirical variogram estimates. 

  
  
An object of class variogram.model represents a fitted variogram model generated by fitting a function to a variogram object. A
variogram.model object is composed of a list consisting of a vector of parameters, \code{parameters}, and a semi-variogram model
function, \code{model}.
}
\note{\code{fit.exponential}, \code{fit.gaussian} and \code{fit.wave}
  use an iterative, Gauss-Newton fitting algorithm to fit to an
  exponential or gaussian variogram model to empirical variogram estimates.
\code{fit.spherical} uses the same algorithm but with differential
  quotients in place of first derivatives. When \code{weighted} is
  \code{T}, the regression is weighted by \eqn{n(h)/gamma(h)^2} where
  the numerator is the number of pairs of points in a given lag.

  Setting \code{iterations} to 0 means no fit procedure is applied. Thus
  parameter values from external sources can be plugged into a variogram
  model object.
  }
\seealso{\code{\link{est.variogram}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.v"))==0){example(est.variogram)}
}
#
# automatic fit:
#
maas.vmod<-fit.gaussian(maas.v,c0=60000,cg=110000,ag=800,plot.it=T,
iterations=30)
#
# iterations=0, means no fit, intended for "subjective" fit
#
maas.vmod.fixed<-fit.variogram("gaussian",maas.v,nugget=60000,sill=110000,range=800,plot.it=T,iterations=0)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
