% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadePropWall.R
\name{shadePropWall}
\alias{shadePropWall}
\title{Shaded proportion of building walls}
\usage{
shadePropWall(seg, seg_height_field, build, build_height_field, solar_pos,
  sample_dist = 1, shift_dist = 0.01, messages = TRUE)
}
\arguments{
\item{seg}{A \code{SpatialLinesDataFrame} object where each feature is a single segment representing a wall.}

\item{seg_height_field}{The name of the column with wall height in \code{seg}}

\item{build}{A \code{SpatialPolygonsDataFrame} object specifying the buildings outline}

\item{build_height_field}{The name of the column with building height in \code{build}}

\item{solar_pos}{A matrix with the solar azimuth (in degrees from North), and elevation}

\item{sample_dist}{Distance between sampling points along wall}

\item{shift_dist}{The distance for shifting the examined locations away from wall to avoid self-shading. Default is 1 cm.}

\item{messages}{Whether a message regarding distance units of the CRS should be displayed.}
}
\value{
Proportion of shaded area of the given segment.
}
\description{
Calculates the shaded proportion of a segment (usually representing a building wall),
given the segment vertical height as well as the outlines and heights of obstacles
(usually buildings).
}
\note{
For a correct geometric calculation, make sure that:\itemize{
\item{The layers \code{location} and \code{build} are projected}
\item{The values in \code{height_field} of \code{build} are given in the same distance units as the CRS (e.g. meters when using UTM)}
}
}
\examples{
data(build)
time = as.POSIXct("2004-12-24 13:30:00", tz = "Asia/Jerusalem")
solar_pos = maptools::solarpos(
  matrix(c(34.7767978098526, 31.9665936050395), ncol = 2),
  time
)
seg = shadow::toSeg(build[2, ])[5:10, ]

# Calculate shade proportion for walls 5-10 of 2nd building
props = shadePropWall(
  seg = seg,
  seg_height_field = "BLDG_HT",
  build = build,
  build_height_field = "BLDG_HT",
  solar_pos = solar_pos,
  sample_dist = 1,
  shift_dist = 0.01
)

# Plot
plot(build)
plot(seg, add = TRUE, col = "red", lwd = 2)
raster::text(rgeos::gCentroid(seg, byid = TRUE), round(props, 2), cex = 0.75)

}

