% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{Argmax}
\alias{Argmax}
\title{Calibrated parameters}
\usage{
Argmax(stability)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{BiSelection}} or \code{\link{GraphicalModel}}.}
}
\value{
A matrix of parameter values. If applied to the output of
  \code{\link{VariableSelection}} or \code{\link{GraphicalModel}}, the first
  column (\code{lambda}) denotes the calibrated hyper-parameter of the
  underlying algorithm. The second column (\code{pi}) is the calibrated
  threshold in selection/co-membership proportions. For multi-block graphical
  models, rows correspond to different blocks. If applied to the output of
  \code{\link{BiSelection}}, all columns are named as in object
  \code{summary}.
}
\description{
Extracts calibrated parameter values in stability selection.
}
\examples{
## Graphical modelling

# Data simulation
set.seed(1)
simul <- SimulateGraphical(pk = 20)

# Stability selection
stab <- GraphicalModel(xdata = simul$data)

# Extracting calibrated parameters
Argmax(stab)
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}},
  \code{\link{BiSelection}}

Other calibration functions: 
\code{\link{Adjacency}()},
\code{\link{ArgmaxId}()},
\code{\link{CalibrationPlot}()},
\code{\link{SelectedVariables}()},
\code{\link{SelectionProportions}()}
}
\concept{calibration functions}
