% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDECquery.R
\name{CDECquery}
\alias{CDECquery}
\title{Easy Access to the CDEC API}
\usage{
CDECquery(id, sensor, interval = "D", start, end)
}
\arguments{
\item{id}{station ID (e.g. 'spw'), single value or vector of station IDs, see details}

\item{sensor}{the sensor ID, single value or vector of sensor numbers, see details}

\item{interval}{character, 'D' for daily, 'H' for hourly, 'M' for monthly, 'E' for event: see Details.}

\item{start}{starting date, in the format 'YYYY-MM-DD'}

\item{end}{ending date, in the format 'YYYY-MM-DD'}
}
\value{
A \code{data.frame} object with the following fields: \code{datetime}, \code{year}, \code{month}, \code{value}.
}
\description{
A (relatively) simple interface to the CDEC website.
}
\details{
Sensors that report data on an \code{interval} other than monthly ('M'), daily ('D'), or hourly ('H') can be queried with an \code{event} interval ('E'). Soil moisture and temperature sensors are an example of this type of reporting. See examples below.

\describe{
\item{1.}{Station IDs can be found here: \url{http://cdec.water.ca.gov/staInfo.html}}
\item{2a.}{Sensor IDs can be found using this URL: \url{http://cdec.water.ca.gov/dynamicapp/staMeta?station_id=}, followed by the station ID.}
\item{2b.}{Sensor details can be accessed using \code{\link{CDEC_StationInfo} with the station ID.}}
\item{3.}{Resevoir capacities can be found here: \url{http://cdec.water.ca.gov/misc/resinfo.html}}
\item{4.}{A new interactive map of CDEC stations can be found here: \url{http://cdec.water.ca.gov}}
}
}
\references{
\url{http://cdec.water.ca.gov/queryCSV.html}
}
\seealso{
\code{\link{CDECsnowQuery}} \code{\link{CDEC_StationInfo}}
}
\author{
D.E. Beaudette
}
