% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSoilMoistureState.R
\name{estimateSoilMoistureState}
\alias{estimateSoilMoistureState}
\title{A very simple estimation of soil moisture state based on volumetric water content}
\usage{
estimateSoilMoistureState(VWC, U, sat, fc, pwp)
}
\arguments{
\item{VWC}{vector of volumetric water content (VWC), range is 0-1}

\item{U}{vector of surplus water (mm)}

\item{sat}{satiation water content, range is 0-1}

\item{fc}{field capacity water content, range is 0-1}

\item{pwp}{permanent wilting point water content, range is 0-1}
}
\value{
vector of moisture states (ordered factor)
}
\description{
This is a very simple classification of volumetric water content (VWC) into 5 "moisture states", based on an interpretation of water retention thresholds. Classification is performed using VWC at satiation, field capacity (typically 1/3 bar suction), permanent wilting point (typically 15 bar suction), and water surplus in mm. The inputs to this function are closely aligned with the assumptions and output from \code{hydromad::hydromad(sma = 'bucket', ...)}.

Soil moisture classification rules are as follows:
\itemize{
\item VWC <= \code{pwp}: "very dry"
\item VWC > \code{pwp} and <= (mid-point between \code{fc} and \code{pwp}): "dry"
\item VWC > (mid-point between \code{fc} and \code{pwp}) and <= \code{fc}: "moist"
\item VWC > \code{fc}: "very moist"
\item \code{U} (surplus) > 2mm: "saturated / runoff"
}
}
\examples{

# "very moist"
estimateSoilMoistureState(VWC = 0.3, U = 0, sat = 0.35, fc = 0.25, pwp = 0.15)

# "very dry"
estimateSoilMoistureState(VWC = 0.15, U = 0, sat = 0.35, fc = 0.25, pwp = 0.15)

}
\author{
D.E. Beaudette
}
