#' Calculates the chernoff bound simulations.
#'
#' @description Calculates different values of shattering coefficient and delta,
#' varying # of samples to study the chernoff bound of SLT.
#'
#' @param rpart.tree rpart.tree. A Decision tree generated by rpart package.
#' @param n_experimentations int. The # of experimentations and samples to run.
#' @param epsilon float. The epsilon to be used in the delta calculation.
#'
#' @usage chernoff_bound(rpart.tree, n_experimentations, epsilon)
#'
#' @return No return value, the function plots the chernoff bound.
#'
#' @export chernoff_bound
chernoff_bound <- function(rpart.tree, n_experimentations=2000, epsilon=.05){
    if(exists("rpart.tree")){
        deltas = NULL

        for (i in seq(1, n_experimentations)){
            shattering <- compute_shattering(rpart.tree, i)
            deltas <- c(deltas, 2*shattering*exp(-i*((epsilon**2)/4)))
        }

        plot(deltas, main="Values of delta by # of samples",
             ylab=expression(delta), xlab="# of samples")

    } else{
        stop("There is no object rpart.tree")
    }
}
