% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{writeTargetingDistance}
\alias{writeTargetingDistance}
\title{Write targeting model distances to a file}
\usage{
writeTargetingDistance(model, file)
}
\arguments{
\item{model}{\link{TargetingModel} object with 
mutation likelihood information.}

\item{file}{name of file to write.}
}
\description{
\code{writeTargetingDistance} writes a 5-mer targeting distance matrix 
to a tab-delimited file.
}
\details{
The targeting distance write as a tab-delimited 5x3125 matrix. Rows define the mutated 
nucleotide at the center of each 5-mer, one of \code{c("A", "C", "G", "T", "N")}, 
and columns define the complete 5-mer of the unmutated nucleotide sequence. 
\code{NA} values in the distance matrix are replaced with distance 0.
}
\examples{
\dontrun{
# Write HS5F targeting model to working directory as hs5f.tab
writeTargetingModel(HH_S5F, "hh_s5f.tsv") 
}

}
\seealso{
Takes as input a \link{TargetingModel} object and calculates  
          distances using \link{calcTargetingDistance}.
}
