% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{plotBaselineSummary}
\alias{plotBaselineSummary}
\title{Plots BASELINe summary statistics}
\usage{
plotBaselineSummary(baseline, idColumn, groupColumn = NULL,
  groupColors = NULL, subsetRegions = NULL, facetBy = c("region",
  "group"), title = NULL, style = c("mean"), size = 1, silent = FALSE,
  ...)
}
\arguments{
\item{baseline}{either a data.frame returned from \link{summarizeBaseline}
or a \code{Baseline} object returned from \link{groupBaseline}
containing selection probability density functions and summary 
statistics.}

\item{idColumn}{name of the column in \code{baseline} containing primary identifiers. 
If the input is a \code{Baseline} object, then this will be a column
in the \code{stats} slot of \code{baseline}.}

\item{groupColumn}{name of the column in \code{baseline} containing secondary grouping 
identifiers. If the input is a \code{Baseline} object, then this will 
be a column in the \code{stats} slot of \code{baseline}.}

\item{groupColors}{named vector of colors for entries in \code{groupColumn}, with 
names defining unique values in the \code{groupColumn} and values
being colors. Also controls the order in which groups appear on the
plot. If \code{NULL} alphabetical ordering and a default color palette 
will be used. Has no effect if \code{facetBy="group"}.}

\item{subsetRegions}{character vector defining a subset of regions to plot, correspoding 
to the regions for which the \code{baseline} data was calculated. If
\code{NULL} all regions in \code{baseline} are plotted.}

\item{facetBy}{one of c("group", "region") specifying which category to facet the
plot by, either values in \code{groupColumn} ("group") or regions
defined in \code{baseline} ("region"). The data that is not used
for faceting will be color coded.}

\item{title}{string defining the plot title.}

\item{style}{type of plot to draw. One of:
\itemize{
  \item \code{"mean"}:     plots the mean and confidence interval for
                           the selection scores of each value in 
                           \code{idColumn}. Faceting and coloring
                           are determine by values in \code{groupColumn}
                           and regions defined in \code{baseline}, 
                           depending upon the \code{facetBy} argument.
}}

\item{size}{numeric scaling factor for lines, points and text in the plot.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A ggplot object defining the plot.
}
\description{
\code{plotBaselineSummary} plots a summary of the results of selection analysis 
using the BASELINe method.
}
\examples{
\donttest{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgM", "IgG"))

# Collapse clones
db <- collapseClones(db, sequenceColumn="SEQUENCE_IMGT",
                     germlineColumn="GERMLINE_IMGT_D_MASK",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="SEQUENCE_IMGT",
                         germlineColumn="GERMLINE_IMGT_D_MASK", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)
 
# Grouping the PDFs by sample and isotype annotations
grouped <- groupBaseline(baseline, groupBy=c("SAMPLE", "ISOTYPE"))

# Plot mean and confidence interval by region with custom group colors
isotype_colors <- c("IgM"="darkorchid", "IgD"="firebrick", 
                    "IgG"="seagreen", "IgA"="steelblue")
plotBaselineSummary(grouped, "SAMPLE", "ISOTYPE", 
                    groupColors=isotype_colors)

# Facet by group instead of region
plotBaselineSummary(grouped, "SAMPLE", "ISOTYPE", facetBy="group")
}

}
\seealso{
Takes as input either a \link{Baseline} object returned by \link{groupBaseline} 
          or a data.frame returned from \link{summarizeBaseline}.
}
