% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{ChoiceGroup}
\alias{ChoiceGroup}
\alias{ChoiceGroup.shinyInput}
\alias{updateChoiceGroup.shinyInput}
\title{ChoiceGroup}
\usage{
ChoiceGroup(...)

ChoiceGroup.shinyInput(inputId, ..., value = defaultValue)

updateChoiceGroup.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
Radio buttons (\code{ChoiceGroup}) let people select a single option from two or more choices.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/ChoiceGroup}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ componentRef }} {\verb{IRefObject<IChoiceGroupOption>} \cr Optional callback to access the IChoiceGroup interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ focused }} {\code{boolean} \cr Indicates if the ChoiceGroupOption should appear focused, visually}
\item {\bold{ name }} {\code{string} \cr This value is used to group each ChoiceGroupOption into the same logical ChoiceGroup}
\item {\bold{ onBlur }} {\verb{(ev: React.FocusEvent<HTMLElement>, props?: IChoiceGroupOption) => void} \cr A callback for receiving a notification when the choice has lost focus.}
\item {\bold{ onChange }} {\verb{(evt?: React.FormEvent<HTMLElement | HTMLInputElement>, props?: IChoiceGroupOption) => void} \cr A callback for receiving a notification when the choice has been changed.}
\item {\bold{ onFocus }} {\verb{(ev?: React.FocusEvent<HTMLElement | HTMLInputElement>, props?: IChoiceGroupOption) => void | undefined} \cr A callback for receiving a notification when the choice has received focus.}
\item {\bold{ required }} {\code{boolean} \cr If true, it specifies that an option must be selected in the ChoiceGroup before submitting the form}
\item {\bold{ theme }} {\code{ITheme} \cr Theme (provided through customization.)}
\item {\bold{ ariaLabelledBy }} {\code{string} \cr ID of an element to use as the aria label for this ChoiceGroup.}
\item {\bold{ componentRef }} {\verb{IRefObject<IChoiceGroup>} \cr Optional callback to access the IChoiceGroup interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ defaultSelectedKey }} {\code{string | number} \cr The key of the option that will be initially checked.}
\item {\bold{ label }} {\code{string} \cr Descriptive label for the choice group.}
\item {\bold{ onChange }} {\verb{(ev?: React.FormEvent<HTMLElement | HTMLInputElement>, option?: IChoiceGroupOption) => void} \cr A callback for receiving a notification when the choice has been changed.}
\item {\bold{ onChanged }} {\verb{(option: IChoiceGroupOption, evt?: React.FormEvent<HTMLElement | HTMLInputElement>) => void} \cr Deprecated and will be removed by 07/17/2017. Use \code{onChange} instead.}
\item {\bold{ options }} {\code{IChoiceGroupOption[]} \cr The options for the choice group.}
\item {\bold{ selectedKey }} {\code{string | number} \cr The key of the selected option. If you provide this, you must maintain selection state by observing onChange events and passing a new value in when changed.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IChoiceGroupStyleProps, IChoiceGroupStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme (provided through customization).}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Use radio buttons when there are two to seven options, you have enough screen space, and the options are important enough to be a good use of that screen space.
\item If there are more than seven options, use a drop-down menu instead.
\item To give people a way to select more than one option, use check boxes instead.
\item If a default option is recommended for most people in most situations, use a drop-down menu instead.
\item Align radio buttons vertically instead of horizontally, if possible. Horizontal alignment is harder to read and localize. If there are only two mutually exclusive options, combine them into a single check box or toggle. For example, use a check box for "I agree" statements instead of radio buttons for "I agree" and "I disagree".
}
}

\subsection{Content}{
\itemize{
\item List the options in a logical order, such as most likely to be selected to least, simplest operation to most complex, or least risk to most. Listing options in alphabetical order isn't recommended because the order will change when the text is localized.
\item Select the safest (to prevent loss of data or system access), most secure, and most private option as the default. If safety and security aren't factors, select the most likely or convenient option.
\item Use a phrase for the label, rather than a full sentence.
\item Make sure to give people the option to not make a choice. For example, include a "None" option.
}
}
}

\examples{
library(shiny.fluent)

if (interactive()) {
  options <- list(
    list(key = "A", text = "Option A"),
    list(key = "B", text = "Option B"),
    list(key = "C", text = "Option C")
  )

  shinyApp(
    ui = div(
      ChoiceGroup.shinyInput("choice", value = "B", options = options),
      textOutput("groupValue")
    ),
    server = function(input, output) {
      output$groupValue <- renderText({
        sprintf("Value: \%s", input$choice)
      })
    }
  )
}
}
