% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{vertical_layout}
\alias{vertical_layout}
\alias{verticalLayout}
\title{Vertical layout}
\usage{
vertical_layout(
  ...,
  rows_heights = NULL,
  cell_args = "",
  adjusted_to_page = TRUE
)

verticalLayout(..., fluid = NULL)
}
\arguments{
\item{...}{Unnamed arguments will become child elements of the layout.}

\item{rows_heights}{Character or numeric vector indicating the widths of the
individual cells. Recycling will be used if needed.}

\item{cell_args}{character with additional attributes that should be used for
each cell of the layout.}

\item{adjusted_to_page}{if TRUE it adjust elements position in equal spaces to
the size of the page}

\item{fluid}{not supported yet (here for consistency with \code{shiny})}
}
\value{
vertical layout grid object
}
\description{
Lays out elements vertically, one by one below one another.
}
\examples{
if (interactive()) {
  ui <- semanticPage(
    verticalLayout(
      a(href="http://example.com/link1", "Link One"),
      a(href="http://example.com/link2", "Link Two"),
      a(href="http://example.com/link3", "Link Three")
    )
  )
  shinyApp(ui, server = function(input, output) { })
}
if (interactive()) {
  ui <- semanticPage(
    vertical_layout(h1("Title"), h4("Subtitle"), p("paragraph"), h3("footer"))
  )
  shinyApp(ui, server = function(input, output) { })
}
}
