% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-textarea.R
\name{textAreaInput}
\alias{textAreaInput}
\title{Create a textarea input control}
\usage{
textAreaInput(inputId, label, value = "", width = NULL,
  height = NULL, cols = NULL, rows = NULL, placeholder = NULL,
  resize = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}

\item{height}{The height of the input, e.g. \code{'400px'}, or
\code{'100\%'}; see \code{\link{validateCssUnit}}.}

\item{cols}{Value of the visible character columns of the input, e.g.
\code{80}. If used with \code{width}, \code{width} will take precedence in
the browser's rendering.}

\item{rows}{The value of the visible character rows of the input, e.g.
\code{6}. If used with \code{height}, \code{height} will take precedence in
the browser's rendering.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{resize}{Which directions the textarea box can be resized. Can be one of
\code{"both"}, \code{"none"}, \code{"vertical"}, and \code{"horizontal"}.
The default, \code{NULL}, will use the client browser's default setting for
resizing textareas.}
}
\value{
A textarea input control that can be added to a UI definition.
}
\description{
Create a textarea input control for entry of unstructured text values.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  textAreaInput("caption", "Caption", "Data Summary", width = "1000px"),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$caption })
}
shinyApp(ui, server)

}
}
\seealso{
\code{\link{updateTextAreaInput}}

Other input elements: \code{\link{actionButton}},
  \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}}, \code{\link{dateInput}},
  \code{\link{dateRangeInput}}, \code{\link{fileInput}},
  \code{\link{numericInput}}, \code{\link{passwordInput}},
  \code{\link{radioButtons}}, \code{\link{selectInput}},
  \code{\link{sliderInput}}, \code{\link{submitButton}},
  \code{\link{textInput}}, \code{\link{varSelectInput}}
}
\concept{input elements}
