% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_gitlab_ci.R
\name{set_gitlab_ci}
\alias{set_gitlab_ci}
\title{Configure GitLab CI pipeline for Docker builds}
\usage{
set_gitlab_ci(path)
}
\arguments{
\item{path}{A character string specifying the path to the directory where
the \code{.gitlab-ci.yml} file will be copied. Defaults to the current directory ('.').}
}
\value{
A logical value indicating whether the file was successfully copied (\code{TRUE}) or not (\code{FALSE}).
}
\description{
Set the \code{gitlab-ci.yml} file provided by the
\code{shiny2docker} package to the specified directory. The GitLab CI configuration
is designed to build a Docker image and push the created image to the GitLab container registry.
}
\examples{
# Copy the .gitlab-ci.yml file to the current directory
set_gitlab_ci(path=tempdir())
}
