% Generated by roxygen2 (4.0.1): do not edit by hand
\name{parseFilePaths}
\alias{parseFilePaths}
\title{Convert the output of a file choice to a data frame}
\usage{
parseFilePaths(roots, files)
}
\arguments{
\item{roots}{The path to the root as specified in the \code{shinyFileChoose()}
call in \code{shinyServer()}}

\item{files}{The corresponding input variable to be parsed}
}
\value{
A data frame mathcing the format of \code{link[shiny]{fileInput}}
}
\description{
This function takes the value of a shinyFiles button input variable and
converts it to a data frame of the same format as that provided by
\code{\link[shiny]{fileInput}}. The only caveat is that the MIME type cannot
be inferred so this will always be an empty string.
}
\details{
The use of \code{parseFilePaths} makes it easy to substitute fileInput and
shinyFiles in your code as code that relies on the values of a file selection
doesn't have to change.
}
\examples{
\dontrun{
ui <- shinyUI(bootstrapPage(
    shinyFilesButton('files', 'File select', 'Please select a file', FALSE)
    verbatimTextOutput('filepaths')
))
server <- shinyServer(function(input, output) {
    output$files <- shinyFileChoose(input, 'files', roots=c(wd='.'),
    filetypes=c('', '.txt'))
    output$filepaths <- renderText({parseFilePaths('.', input$files)})
})

runApp(list(
    ui=ui,
    server=server
))
}
}
\seealso{
Other shinyFiles: \code{\link{shinyFileChoose}};
  \code{\link{shinyFilesButton}};
  \code{\link{shinyFilesExample}}
}

