% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gov_layout.R
\name{gov_layout}
\alias{gov_layout}
\title{Page Layout Function}
\usage{
gov_layout(..., inputID = "main", size = "full")
}
\arguments{
\item{...}{include the components of the UI that you want within the
main page.}

\item{inputID}{ID of the main div.  Defaults to "main"}

\item{size}{Layout of the page.  Optional are full, one-half, two-thirds,
one-third and one-quarter.  Defaults to "full"}
}
\value{
a html shiny layout div
}
\description{
This function loads the page layout, This doesn't work as well as
the `gov_main_layout` and associated functions.  This is being kept for now
as a simpler version where grids are not needed.
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::gov_layout(size = "full",
      shinyGovstyle::panel_output(
        inputId = "panel1",
        main_text = "Application Complete",
        sub_text = "Thank you for submitting your application.
        Your reference is xvsiq")
    ),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {}
  shinyApp(ui = ui, server = server)
}
}
\keyword{style}
