% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_h2o.R
\name{shiny_h2o}
\alias{shiny_h2o}
\title{Implement a shiny web app to compare h2o supervised regression models on time series}
\usage{
shiny_h2o(data = data, x, y, date_column, share_app = FALSE,
  port = NULL)
}
\arguments{
\item{data}{Time serie containing one or more input values and one output value. 
The time serie must be a data.frame or a data.table and must contain at least one time-based column on Date or POSIXct format.}

\item{x}{Vector of numerical and categorical input variables used to train and test the model. Each element of x vector must correspond to a data column with either numerical or factor type.}

\item{y}{the numerical output variable to forecast (must correpond to one data column)}

\item{date_column}{the name of time-based column ( must correspond to one data column). Must correspond to Date or POSIXct format.}

\item{share_app}{a logical value indicating whether the app must be shared on local LAN}

\item{port}{a four-digit number corresponding to the port the application should listen to. This parameter is necessary only  if share_app option is set to TRUE}
}
\description{
This function creates in one line of code a shareable web app to compare supervised regression model performance (framework: H2O).
}
\examples{
\dontrun{
library(shinyML)
longley2 <- longley \%>\% mutate(Year = as.Date(as.character(Year),format = "\%Y"))
shiny_h2o(data =longley2,x = c("GNP_deflator","Unemployed" ,"Armed_Forces","Employed"),
  y = "GNP",date_column = "Year",share_app = TRUE,port = 3951)
}
}
