% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Accordion.R
\name{updateF7Accordion}
\alias{updateF7Accordion}
\title{Update a Framework 7 accordion}
\usage{
updateF7Accordion(
  inputId,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Accordion instance.}

\item{selected}{Index of item to select.}

\item{session}{Shiny session object}
}
\description{
Update a Framework 7 accordion
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "Accordions",
     f7SingleLayout(
       navbar = f7Navbar("Accordions"),
       f7Button(inputId = "go", "Go"),
       f7Accordion(
         inputId = "myaccordion1",
         f7AccordionItem(
           title = "Item 1",
           f7Block("Item 1 content"),
           open = TRUE
         ),
         f7AccordionItem(
           title = "Item 2",
           f7Block("Item 2 content")
         )
       )
     )
   ),
   server = function(input, output, session) {

     observeEvent(input$go, {
       updateF7Accordion(inputId = "myaccordion1", selected = 2, session = session)
     })

     observe({
       print(
         list(
           accordion1_state = input$myaccordion1$state,
           accordion1_values = unlist(input$myaccordion1$value)
         )
       )
     })
   }
 )
}
}
