% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{insertF7Tab}
\alias{insertF7Tab}
\title{Framework7 tab insertion}
\usage{
insertF7Tab(
  id,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{\link{f7Tabs} id.}

\item{tab}{\link{f7Tab} to insert.}

\item{target}{\link{f7Tab} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
\code{insertF7Tab} inserts an \link{f7Tab} in an \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "Insert a tab Before the target",
     f7TabLayout(
       navbar = f7Navbar(
         title = "Tabs",
         hairline = FALSE,
         shadow = TRUE,
         leftPanel = TRUE,
         rightPanel = TRUE
       ),
       f7Tabs(
         animated = TRUE,
         id = "tabs",
         f7Tab(
           tabName = "Tab 1",
           icon = f7Icon("airplane"),
           active = TRUE,
           "Tab 1",
           f7Button(inputId = "add", label = "Add tabs")
         ),
         f7Tab(
           tabName = "Tab 2",
           icon = f7Icon("today"),
           active = FALSE,
           f7Button(inputId="stay", label = "Stay"),
           "Tab 2"
         )
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$stay, {
       f7Toast("Please stay")
     })
     observeEvent(input$add, {
       insertF7Tab(
         id = "tabs",
         position = "after",
         target = "Tab 1",
         tab = f7Tab (
           # Use multiple elements to test for accessor function
           f7Button(inputId = "add_dynamic", label = "Add dyn"),
           f7Text(inputId = "my_text", label ="Enter something", placeholder = "What?"),
           f7Text(inputId = "my_other", label ="Else:", placeholder = "Else ?"),
           tabName = paste0("tabx_", input$go), "Test2",
           icon = f7Icon("app_badge")
         ),
         select = TRUE
       )
     })
   }
 )
}

}
